// XISLTouchInputTag.cpp: CXISLTouchInputTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLTouchInputTag.h"
#include "XISLVar.h"
#include "XISLExchangeTag.h"
#include "XISLDialogTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLTouchInputTag::CXISLTouchInputTag()
{
	m_nTagType = ID_TAG_INPUT;
	m_nInputType = ID_INPUTTYPE_TOUCH;
	m_nEvent = ID_INPUTEVENT_CLICK;
	m_nBmpID = IDB_TOUCH;
	m_pAttrVar = NULL;
	m_pXVar = NULL;
	m_pYVar = NULL;
	m_pParentTag = NULL;
}

CXISLTouchInputTag::~CXISLTouchInputTag()
{

}

CXISLTouchInputTag::CXISLTouchInputTag(const CXISLTouchInputTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nInputType = cpXISL.m_nInputType;
	m_nEvent = cpXISL.m_nEvent;
	m_strMatch = cpXISL.m_strMatch;
	m_pAttrVar = cpXISL.m_pAttrVar;
	m_pXVar = cpXISL.m_pXVar;
	m_pYVar = cpXISL.m_pYVar;
}

CXISLTouchInputTag& CXISLTouchInputTag::operator=(const CXISLTouchInputTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nInputType = cpXISL.m_nInputType;
		m_nEvent = cpXISL.m_nEvent;
		m_strMatch = cpXISL.m_strMatch;
		m_pAttrVar = cpXISL.m_pAttrVar;
		m_pXVar = cpXISL.m_pXVar;
		m_pYVar = cpXISL.m_pYVar;
	}
	return *this;
}

BOOL CXISLTouchInputTag::SetAttribute(int nEvent,LPCTSTR lpszMatch,CXISLVar *pAttrVar,
									  CXISLVar *pXVar,CXISLVar *pYVar)
{
	m_nEvent = nEvent;
	m_strMatch = lpszMatch;
	m_pAttrVar = pAttrVar;
	m_pXVar = pXVar;
	m_pYVar = pYVar;
	if(m_pAttrVar)
		m_pAttrVar->ReferCount(TRUE);
	if(m_pXVar)
		m_pXVar->ReferCount(TRUE);
	if(m_pYVar)
		m_pYVar->ReferCount(TRUE);
	return TRUE;
}

BOOL CXISLTouchInputTag::SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszMatch,LPCTSTR lpszReturn)
{
	if(strcmp(lpszEvent,XISL_INPUTEVENT[ID_INPUTEVENT_CLICK])==0)
		m_nEvent = ID_INPUTEVENT_CLICK;
	else if(strcmp(lpszEvent,XISL_INPUTEVENT[ID_INPUTEVENT_DCLICK])==0)
		m_nEvent = ID_INPUTEVENT_DCLICK;
	else
		return FALSE;

	m_strMatch = lpszMatch;
	int nEnd = m_strMatch.Find("@");
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	if(nEnd != -1)
	{
		int nStart=nEnd;
		for(;nStart>=0;nStart--)
		{
			if(m_strMatch[nStart]=='[')
				break;
		}
		CString strAttrName = m_strMatch.Mid(nStart+1,nEnd-nStart-1);
		m_strMatch.Delete(nStart+1,nEnd-nStart-1);
		strAttrName.Replace(":=","");
		strAttrName.Remove(' ');

		if(!strAttrName.IsEmpty())
		{
			m_pAttrVar = pExcItem->m_pLocalVar->FindVarWithParent(strAttrName);
			if(m_pAttrVar == NULL)
			{
				m_pAttrVar = new CXISLVar;
				if(m_pAttrVar->SetAttribute(strAttrName,"",FALSE,FALSE) != 0)
				{
					delete m_pAttrVar; m_pAttrVar = NULL;
					return FALSE;
				}
				pExcItem->m_pLocalVar->RegistVar(m_pAttrVar);
			}
			m_pAttrVar->ReferCount(TRUE);
		}
	}
	else
		m_pAttrVar = NULL;

	CString strReturn = lpszReturn;
	if(strReturn.IsEmpty())
	{
		m_pXVar = NULL; m_pYVar = NULL;
		return TRUE;
	}

	int nIndex = strReturn.Find(",");
	if(nIndex==-1)
		return FALSE;
	m_pXVar = pExcItem->m_pLocalVar->FindVarWithParent(strReturn.Left(nIndex));
	if(m_pXVar == NULL)
	{
		m_pXVar = new CXISLVar;
		if(m_pXVar->SetAttribute(strReturn.Left(nIndex),"",FALSE,FALSE) != 0)
		{
			delete m_pXVar; m_pXVar = NULL;
			return FALSE;
		}
		pExcItem->m_pLocalVar->RegistVar(m_pXVar);
	}
	m_pXVar->ReferCount(TRUE);
	m_pYVar = pExcItem->m_pLocalVar->FindVarWithParent(strReturn.Right(strReturn.GetLength()-nIndex-1));
	if(m_pYVar == NULL)
	{
		m_pYVar = new CXISLVar;
		if(m_pYVar->SetAttribute(strReturn.Right(strReturn.GetLength()-nIndex-1),"",FALSE,FALSE) != 0)
		{
			delete m_pYVar; m_pYVar = NULL;
			return FALSE;
		}
		pExcItem->m_pLocalVar->RegistVar(m_pYVar);
	}
	m_pYVar->ReferCount(TRUE);

	return TRUE;
}

LPCTSTR CXISLTouchInputTag::GetMatch()
{
	if(m_pAttrVar)
	{
		m_strMatch.Remove(' ');
		int nStart = m_strMatch.Find("[@");
		if(nStart != -1)
		{
			int nEndEQ = m_strMatch.Find("=",nStart);
			if(nEndEQ != -1)
			{
				int nEnd = m_strMatch.Find("]",nEndEQ);
				int nCount = nEnd - nEndEQ;
				if(nCount)
					m_strMatch.Delete(nEndEQ,nCount);
			}

			CString strVarName;
			m_pAttrVar->GetVarNameEx(strVarName);
			strVarName += " := ";
			m_strMatch.Insert(nStart+1,strVarName);
		}
	}
	return m_strMatch;
}

//LPCTSTR CXISLOprTag::GetXISLString()
//@\@FinputȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLTouchInputTag::GetXISLString()
{
	CString strInputType = XISL_INPUTTYPE[m_nInputType];
	
	m_strXISL = "<input type=\"" + strInputType;
	m_strXISL += "\" event=\"";
	m_strXISL += XISL_INPUTEVENT[m_nEvent];

	if(!m_strMatch.IsEmpty())
	{
		m_strXISL += "\" match=\"";
		m_strXISL += GetMatch();
	}
	if(m_pXVar &&  m_pYVar)
	{
		CString strVarName;
		m_strXISL += "\" return=\"";
		m_pXVar->GetVarNameEx(strVarName);
		m_strXISL += strVarName;
		m_strXISL += ",";
		m_pYVar->GetVarNameEx(strVarName);
		m_strXISL += strVarName;
	}
	m_strXISL += "\" />\r\n";

	return m_strXISL;
}
